 

 IF EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[V_RELATORIO_MOVIMENTO_VENDAS_PRODUTOS]'))
	DROP VIEW V_RELATORIO_MOVIMENTO_VENDAS_PRODUTOS;
GO
CREATE  VIEW V_RELATORIO_MOVIMENTO_VENDAS_PRODUTOS 
AS
	SELECT
		  EST_MOVIMENTO_VENDAS.TIPO_VENDA										AS TipoMovimento
		, V_BI_MOVIMENTO_TIPO.DsTipoMovimento
		, 0																		AS CodigolistaProduto
		, 'Venda por produto' DsListaProduto
		, EST_MOVIMENTO_VENDAS.CD_FILIAL										AS Filial
		, V_BI_FILIAL.GrupoEconomico
		, V_BI_FILIAL.Supervisor
		, V_BI_FILIAL.RegiaoFilial
		, V_BI_FILIAL.Cidade
		, GLB_DT_MOVIMENTO.DT_MOVIMENTO											AS DtMovimento
		, V_BI_EST_PROD.produto
		, V_BI_EST_PROD.Descricao
		, V_BI_EST_PROD.CdLinha
		, V_BI_EST_PROD.Linha
		, V_BI_EST_PROD.Categoria
		, V_BI_EST_PROD.Departamento
		, V_BI_EST_PROD.AreaAtendimento
		, V_BI_EST_PROD.NomeFabricante
		, V_BI_EST_PROD.Segmento
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PMC  )							AS VlrPMC
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_OFERTA  )					AS VlrOferta
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD  )							AS VlrVendaBruta
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_ITENS  )					AS VlrDescItens
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_VERBA  )					AS VlrDescVerba
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DESC_RATEIO  )					AS VlrDescRateio
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ  )						AS VlrVdLiquida
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_MD  )						AS VlrCustoMedio
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO  )						AS VlrCustoUltimo
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CUSTO_GER )						AS VlrCustoGer
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_ICMS  )							AS VlrIcms
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_PIS_COFINS )					AS VlrPisCofins
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_ITENS )						AS QtdeItens
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DINHEIRO  )						AS VlrDinheiro
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES )						AS VlrCheques
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES_VISTA  )				AS VlrChequesVista
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUES_PRAZO  )				AS VlrChequesPrazo
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CARTAO  )						AS VlrCartao
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_TICKETS  )						AS VlrTickets
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_DUPLICATA  )					AS VlrDuplicata
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CONV  )							AS VlrConvenio
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CONV_PBM  )						AS VlrConvenioPbm
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_CHEQUE_TROCO  )					AS VlrChequeTroco
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_NCC )							AS VlrNcc
		--, ISNULL(EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.QTDE_VD,0)  AS QtdeVd

		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.QTDE_VD )							AS QtdeVd
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_COMISSAO  )						AS VlrComissao
		, ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_COMISSAO_FABRIC  ), 0)	AS VlrComissaoFabric
		, ISNULL(FP_FUNC.NM_FUN, 'Nao definido')								AS Vendedor
		, GLB_USU.NM_USU														AS AtendenteCaixa
		, EST_MOVIMENTO_VENDAS_PRODUTOS.CD_VEND									AS CdVendedor
		, ISNULL(SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_RECOMPOSICAO_MARGEM), 0) AS VlrRecomposicaoMargem
		, V_PDV_VD_ORIGEM_VENDA.DS_CD_ORIGEM_VENDA								AS DsOrigemVenda
		, SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_ISSQN)							AS VlrISSQN
		,EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PARCEIRO								AS CodParceiro
		,EST_MOVIMENTO_VENDAS_PRODUTOS.CPF_CLIENTE_PARCEIRO						AS CpfClienteParceiro 
		,EST_MOVIMENTO_VENDAS_PRODUTOS.NOME_CLIENTE_PARCEIRO					AS NomeParceiro 
		,EST_MOVIMENTO_VENDAS_PRODUTOS.TIPO_DESCONTO							AS TipoDesconto
		,EST_MOVIMENTO_VENDAS_PRODUTOS.DS_TIPO_DESCONTO 						AS DescTipoDesconto
    FROM
	   EST_MOVIMENTO_VENDAS 
		 
	   INNER JOIN EST_MOVIMENTO_VENDAS_PRODUTOS  ON   EST_MOVIMENTO_VENDAS_PRODUTOS.CD_EMP = EST_MOVIMENTO_VENDAS.CD_EMP
		AND EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
	 
	   --LEFT OUTER JOIN EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO ON 
		  --EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS	= EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.CD_CTR_VENDAS
	   --AND EST_MOVIMENTO_VENDAS_PRODUTOS.CD_ORIGEM_VENDA	= EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.CD_ORIGEM_VENDA
	   --AND EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PROD			= EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.CD_PROD

		
	   INNER JOIN GLB_DT_MOVIMENTO ON 
	   EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO

	   INNER JOIN V_BI_EST_PROD ON 
	   EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PROD = V_BI_EST_PROD.produto

	   INNER JOIN V_BI_MOVIMENTO_TIPO ON 
	   EST_MOVIMENTO_VENDAS.TIPO_VENDA = V_BI_MOVIMENTO_TIPO.TipoMovimento

	   INNER JOIN V_BI_FILIAL ON 
	   EST_MOVIMENTO_VENDAS.CD_FILIAL = V_BI_FILIAL.filial

	   LEFT OUTER JOIN FP_FUNC ON 
	   EST_MOVIMENTO_VENDAS_PRODUTOS.CD_VEND = FP_FUNC.CD_FUN

	   LEFT OUTER JOIN GLB_USU ON 
	   EST_MOVIMENTO_VENDAS_PRODUTOS.CD_OPERADOR = GLB_USU.CD_USU

	   INNER JOIN V_PDV_VD_ORIGEM_VENDA ON 
	   EST_MOVIMENTO_VENDAS_PRODUTOS.CD_ORIGEM_VENDA = V_PDV_VD_ORIGEM_VENDA.CD_ORIGEM_VENDA
 
	WHERE 
	   EST_MOVIMENTO_VENDAS.TIPO_VENDA IN (0, 2, 3, 10,11)
	GROUP BY
		   EST_MOVIMENTO_VENDAS.CD_FILIAL
		  , EST_MOVIMENTO_VENDAS.TIPO_VENDA
		  , V_BI_MOVIMENTO_TIPO.DsTipoMovimento
		  , V_BI_EST_PROD.Linha
		  , GLB_DT_MOVIMENTO.DT_MOVIMENTO
		  , V_BI_FILIAL.GrupoEconomico
		  , V_BI_FILIAL.Supervisor
		  , V_BI_FILIAL.RegiaoFilial
		  , V_BI_FILIAL.Cidade

		  , V_BI_EST_PROD.Categoria
		  , V_BI_EST_PROD.Departamento
		  , V_BI_EST_PROD.AreaAtendimento

		--  , EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO.QTDE_VD
		  
		  , V_BI_EST_PROD.produto
		  , V_BI_EST_PROD.Descricao
		  
		  , FP_FUNC.NM_FUN
		  , GLB_USU.NM_USU
		 
		  , EST_MOVIMENTO_VENDAS_PRODUTOS.CD_VEND
		  
		  , V_BI_EST_PROD.NomeFabricante
		  , V_BI_EST_PROD.Segmento
		  , V_PDV_VD_ORIGEM_VENDA.DS_CD_ORIGEM_VENDA
		  , V_BI_EST_PROD.CdLinha 
		 ,EST_MOVIMENTO_VENDAS_PRODUTOS.CD_PARCEIRO
		 ,EST_MOVIMENTO_VENDAS_PRODUTOS.CPF_CLIENTE_PARCEIRO
		 ,EST_MOVIMENTO_VENDAS_PRODUTOS.NOME_CLIENTE_PARCEIRO
		 ,EST_MOVIMENTO_VENDAS_PRODUTOS.TIPO_DESCONTO
		 ,EST_MOVIMENTO_VENDAS_PRODUTOS.DS_TIPO_DESCONTO 